function cap = importCap(dataFile)

% Main data
data = readtable(dataFile, 'Sheet', 'main', 'ReadRowNames', 1);

cap.shortName = dataFile;
cap.capacitance = data.value('Nominal capacitance');
cap.eqRes = data.value('Internal resistance');
cap.nomVolt = data.value('Nominal voltage');
cap.maxVolt = data.value('Minimum voltage');
cap.mass = data.value('Mass');

% Read full name
tmp = readcell(dataFile,'Sheet','main');
[i,j] = find(strcmp(tmp,'Full Name'));
cap.fullName = tmp(i,j+1);

end